﻿var defaultMobiscrollSettings = {
    lang: 'en',
    buttons: ["cancel", "clear", "now", "set"],
    circular: false,
    showLabel: true,
    display: "bubble",
    touchUi: false,
    maxWidth: 70,
    rows: 5,
    onShow: function () {
        $('.mbsc-fr-bubble').css("position", "absolute");
        $('.mbsc-fr-bubble .mbsc-fr-persp').css("position", "absolute");
    }
};


$(document).ready(function () {
    defaultMobiscrollSettings.lang = $("html").attr("lang");

    $("div.dateTimeAnswer input.dateTimeAnswer, div.dateTimeAnswer .dateValue").on("change", function () {
        $(this).closest(".questionBackground").find(".choice :radio").prop("checked", false);
        $(this).closest(".questionBackground").find(".choice :radio").trigger("change");
        if (defaultRadioImage) {
            $(this).closest(".questionBackground").find(".choice .radioImage").attr("src", defaultRadioImage);
        }

        // Arabic language time format conversion to English AM/PM
        var currentLanguage = defaultMobiscrollSettings.lang;

        if (currentLanguage === 'ar') {
            var selectedTime = $(this).val();

            // Use a regular expression to extract the hours, minutes, and period (AM/PM)
            var timePattern = /(\d{1,2})-(\d{2})\s*(ص|م)/;
            var match = timePattern.exec(selectedTime);

            if (match) {
                var hours = parseInt(match[1], 10);
                var minutes = match[2];
                var period = match[3];  // "ص" for AM, "م" for PM

                if (period === "م" && hours < 12) {
                    hours += 12; // Convert PM to 24-hour format
                }
                if (period === "ص" && hours === 12) {
                    hours = 0; // Handle 12 AM as 0 in 24-hour format
                }

                // Create a new Date object and format it into English AM/PM
                var date = new Date();
                date.setHours(hours);
                date.setMinutes(minutes);

                var formattedTime = date.toLocaleTimeString('en-US', {
                    hour: '2-digit',
                    minute: '2-digit',
                    hour12: true
                });
                // Replace ':' with '-' to get the desired hh-mm AM/PM format
                formattedTime = formattedTime.replace(":", "-");

                // Set the formatted time back into the input
                $(this).val(formattedTime);
            }
        }
    });

    if (defaultRadioImage) {
        $("div.dateTimeAnswer .radioButton .choice").on("click", function () {
            $(this).closest(".questionBackground").find("input.dateTimeAnswer, .dateValue, .datePartInput").val("");
        });
    }
    else {
        $("div.dateTimeAnswer .choice :radio").on("click", function () {
            $(this).closest(".questionBackground").find("input.dateTimeAnswer, .dateValue, .datePartInput").val("");
        });
    }

    $(".datePartInput").on("change keyup", function () {
        var container = $(this).closest(".dateTimeContent");
        UpdateDateValue(container);

        $(this).closest(".questionBackground").find(".choice :radio").prop("checked", false);
    });

    $("input:text.dateTimeAnswer").on("click", function () {
        CreateDateTimeControlInstance($(this), true);
    });

    $(".calendarIcon").on("click", function () {
        let dateTimeInput = $("input.dateTimeAnswer", $(this).parent());
        CreateDateTimeControlInstance(dateTimeInput, true);
    });

    //-------------Set initial values
    $(".dateTimeContent").each(function () {
        UpdateDateValue($(this));
    });

    $("#ui-datepicker-div").addClass("standard");

    const style = document.createElement('style');

    style.innerHTML = `
        .mbsc-mobiscroll .mbsc-ltr .mbsc-fr-btn-cont {
            text-align: center;
        }
        .mbsc-fr-btn-cont .mbsc-fr-btn-w {
            font-size: 14px;
        }
        .mbsc-fr-bubble,
        .mbsc-fr-bubble .mbsc-fr-persp {
            position: fixed;
        }
    `;
    document.head.appendChild(style);
});

function CreateDateTimeControlInstance(dateTimeInput, createAndOpen) {
    var type = dateTimeInput.attr("data-datetype");
    switch (type) {
        case "DateTime":
            InitializeDateTimePicker(dateTimeInput);
            break;
        case "Date":
            InitializeDatePicker(dateTimeInput, createAndOpen);
            break;
        case "Time":
            InitializeTimePicker(dateTimeInput);
            break;
        case "Year":
            dateTimeInput.autoNumeric({ aPad: false, vMin: '0', vMax: '9999', mDec: '0', aSep: '' });
            break;
        case "Month":
            dateTimeInput.autoNumeric({ aPad: false, vMin: '1', vMax: '12', mDec: '0', aSep: '' });
            break;
        case "Day":
            dateTimeInput.autoNumeric({ aPad: false, vMin: '1', vMax: '31', mDec: '0', aSep: '' });
            break;
        case "Hours":
            dateTimeInput.autoNumeric({ aPad: false, vMin: '0', vMax: '24', mDec: '0', aSep: '' });
            break;
        case "Minutes":
            dateTimeInput.autoNumeric({ aPad: false, vMin: '0', vMax: '60', mDec: '0', aSep: '' });
            break;
    }
}

function UpdateDateValue(container) {
    var input = $(".dateValue", container);

    if (input.length > 0) {
        var value = "";
        var hasValue = false;

        container.find("span").each(function () {
            if ($(this).hasClass("datePart")) {
                var partValue = $(this).find(".datePartInput").val();

                if (partValue) {
                    value += partValue;
                    hasValue = true;
                }
            }
            else {
                value += $(this).text();
            }
        });

        input.val(hasValue ? value : "");
    }
}

function InitializeDateTimePicker(input) {
    var displayCalendar = input.attr("data-displaycalendar") == "true";

    if (displayCalendar) {
        var dateFormat = "y-mm-dd";
        if (input.attr("data-dateformat") != null)
            dateFormat = input.attr("data-dateformat");

        var timeFormat = input.attr("data-timeformat").replace(/m/g, "i").replace("tt", "A");
        var dateTimeFormat = dateFormat + " " + timeFormat;

        var minValue = getMinimumDateFromDateInput(input, dateTimeFormat);
        var maxValue = getMaximumDateFromDateInput(input, dateTimeFormat);

        var disabledDates = getDisabledDates(input.attr("data-disabled-dates"), dateFormat);

        var options = $.extend(defaultMobiscrollSettings, {
            controls: ["calendar", "time"],
            dateFormat: dateFormat,
            dateOrder: dateFormat.replace(/[^A-Za-z]/g, ""),
            timeFormat: timeFormat,
            timeWheels: timeFormat.replace(/[^A-Za-z]/g, ""),
            preset: "date",
            invalid: disabledDates,
            min: minValue,
            max: maxValue
        });

        mobiscroll.calendar(input, options).show();
    }
}

function InitializeDatePicker(input) {
    var displayCalendar = input.attr("data-displaycalendar") === "true";

    if (displayCalendar) {
        input.get(0).type = "text";

        var dateFormat = "y-mm-dd";
        if (input.attr("data-dateformat") != null)
            dateFormat = input.attr("data-dateformat");

        var minValue = getMinimumDateFromDateInput(input, dateFormat);
        var maxValue = getMaximumDateFromDateInput(input, dateFormat);

        var disabledDates = getDisabledDates(input.attr("data-disabled-dates"), dateFormat);


        var options = $.extend(defaultMobiscrollSettings, {
            controls: ["calendar"],
            dateFormat: dateFormat,
            dateOrder: dateFormat.replace(/[^A-Za-z]/g, ""),
            preset: "date",
            invalid: disabledDates,
            min: minValue,
            max: maxValue
        });

        mobiscroll.calendar(input, options).show();
    }
}

function InitializeTimePicker(input) {
    var displayCalendar = input.attr("data-displaycalendar") == "true";

    if (displayCalendar) {
        var timeFormat = input.attr("data-timeformat").replace(/m/g, "i").replace("tt", "A");

        var minValue = getMinimumDateFromDateInput(input, timeFormat);
        var maxValue = getMaximumDateFromDateInput(input, timeFormat);

        var options = $.extend(defaultMobiscrollSettings, {
            steps: {
                minute: 1
            },
            controls: ["time"],
            timeFormat: timeFormat,
            timeWheels: timeFormat.replace(/[^A-Za-z]/g, ""),
            min: minValue,
            max: maxValue
        });

        mobiscroll.calendar(input, options).show();
    }
}